<?php
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

define('IN_SCRIPT',1);
define('HESK_PATH','');
require(HESK_PATH . 'hesk_settings.inc.php');
require(HESK_PATH . 'inc/common.inc.php');

if (function_exists('hesk_load_database_functions'))
{
    hesk_load_database_functions();
}
else
{
    require(HESK_PATH . 'inc/database.inc.php');
}

// Get IP
$ip = ! empty($_GET['ip']) ? $_GET['ip'] : $_SERVER['REMOTE_ADDR'];

hesk_dbConnect();

// Remove all IPs or just a single one?
if (strtolower($ip) == 'all')
{
    hesk_dbQuery("TRUNCATE `".hesk_dbEscape($hesk_settings['db_pfix'])."logins`");
    $msg = '<span style="color:green">Success:</span> logins table has been emptied.';
}
else
{
    $ip = preg_replace('/[^0-9\.\:]/', '', $ip);
    hesk_dbQuery("DELETE FROM `".hesk_dbEscape($hesk_settings['db_pfix'])."logins` WHERE `ip` LIKE '{$ip}'");

    if (hesk_dbAffectedRows() > 0)
    {
    	$msg = '<span style="color:green">Success:</span> IP address <b>'.$ip.'</b> has been removed from the logins database.';
    }
    else
    {
    	$msg = '<span style="color:orange">Notice:</span> IP address <b>'.$ip.'</b> is not banned, no changes made.';
    }
}

echo '&nbsp;<br>'.$msg.'<br><br><span style="color:red">DELETE THIS FILE FROM THE SERVER!</span>';
