<?php
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

define('IN_SCRIPT',1);
define('HESK_PATH','');

/* Get all the required files and functions */
require(HESK_PATH . 'hesk_settings.inc.php');
require(HESK_PATH . 'inc/common.inc.php');
hesk_load_database_functions();
hesk_dbConnect();
?>
<!doctype html>
<html lang=en>
<head>
    <meta charset=utf-8>
    <title>Multi-factor authentication reset script</title>
</head>
<body>
    <hr>
    <p>Use this tool to disable multi-factor authentication (MFA) if you no longer have access to your email or MFA device.</p>
    <p style="color:red">For security reasons, <strong>delete this file from the server</strong> after you are done..</p>
    <hr>
    <p>&nbsp;</p>
    <?php
    if (isset($_POST['user'])) {
        echo reset_mfa($_POST['user']);
        echo "<p>&nbsp;</p>";
    }

    // Get users with mfa_enrollment set
    $users = array();
    $res = hesk_dbQuery('SELECT * FROM `'.hesk_dbEscape($hesk_settings['db_pfix']).'users` WHERE `mfa_enrollment` <> 0 ORDER BY `name` ASC');
    $num_found = hesk_dbNumRows($res);

    if ($num_found < 1) {
        echo '<p style="color:blue">No users with MFA enabled found in your database.</p>';
    } else {
        ?>
        <form action="disable-mfa.php" method="post">
            <label for="user">Disable MFA for:</label>
            <select name="user">
                <?php
                if ($num_found > 1) {
                    echo '<option value=""> - click to select - </option>';
                    echo '<option value="0">ALL users</option>';
                }

                while ($user = hesk_dbFetchAssoc($res)) {
                    echo '<option value="'.$user['id'].'">'.$user['name'].'</option>';
                }
                ?>
            </select>
            <input type="submit" value="Disable MFA">
        </form>
        <?php
    }
    ?>
</body>
</html>
<?php

function reset_mfa($user_id) {
    global $hesk_settings, $hesklang;

    if ($user_id == '') {
        return '<p style="color:red">Please select for which user you want to disable MFA.</p>';
    }

    $user_id = intval($user_id);

    // Reset a single user
    if ($user_id) {

        $res = hesk_dbQuery("SELECT * FROM `".hesk_dbEscape($hesk_settings['db_pfix'])."users` WHERE `id` = {$user_id}");
        if (hesk_dbNumRows($res) < 1) {
            return '<p style="color:red">User with ID '.$myuser.' not found in your database.</p>';
        }
        $user = hesk_dbFetchAssoc($res);

        hesk_dbQuery("UPDATE `".hesk_dbEscape($hesk_settings['db_pfix'])."users` SET `mfa_enrollment` = 0, `mfa_secret` = NULL WHERE `id` = {$user_id}");
        if (hesk_dbAffectedRows() != 1) {
            return '<p style="color:blue">'.$user['name'].' does not have MFA enabled, no changes made to the database.</p>';
        }

        hesk_dbQuery("DELETE FROM `".hesk_dbEscape($hesk_settings['db_pfix'])."mfa_backup_codes` WHERE `user_id` = ".intval($user_id));
        hesk_dbQuery("DELETE FROM `" . hesk_dbEscape($hesk_settings['db_pfix']) . "mfa_verification_tokens`
                    WHERE `user_id` = " . intval($user_id));

        return '<p style="color:green">Multi-factor authentication has been disabled for '.$user['name'].'.</p>';
    }

    // reset all users
    hesk_dbQuery("UPDATE `".hesk_dbEscape($hesk_settings['db_pfix'])."users` SET `mfa_enrollment` = 0, `mfa_secret` = NULL");
    hesk_dbQuery("TRUNCATE `".hesk_dbEscape($hesk_settings['db_pfix'])."mfa_backup_codes`");
    hesk_dbQuery("TRUNCATE `" . hesk_dbEscape($hesk_settings['db_pfix']) . "mfa_verification_tokens`");

    return '<p style="color:green">Multi-factor authentication has been disabled for all users.</p>';
}

